"""Boolean gates (contiguity, orientation uniqueness, CRA stub)."""
from __future__ import annotations
from dataclasses import dataclass

@dataclass
class GateConfig:
    contiguity: bool = True
    persistence: bool = True
    orientation_unique: bool = True
    CRA_mode: str = "stub"

def orientation_ok(last_dx: int, new_dx: int) -> bool:
    # Forbid immediate left-then-right or right-then-left
    if last_dx == 0 or new_dx == 0:
        return True
    return (last_dx == new_dx)

def contiguity_ok(dx: int) -> bool:
    return dx in (-1, 0, +1)
